/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.block;

import com.google.common.base.Preconditions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class CraftSign
extends CraftBlockEntityState<SignBlockEntity>
implements Sign {
    private String[] originalLines = null;
    private String[] lines = null;

    public CraftSign(World world, SignBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    @Override
    public String[] getLines() {
        if (this.lines == null) {
            SignBlockEntity sign = (SignBlockEntity)this.getSnapshot();
            this.lines = new String[sign.f_59720_.length];
            System.arraycopy(CraftSign.revertComponents(sign.f_59720_), 0, this.lines, 0, this.lines.length);
            this.originalLines = new String[this.lines.length];
            System.arraycopy(this.lines, 0, this.originalLines, 0, this.originalLines.length);
        }
        return this.lines;
    }

    @Override
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.getLines()[index];
    }

    @Override
    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.getLines()[index] = line;
    }

    @Override
    public boolean isEditable() {
        return ((SignBlockEntity)this.getSnapshot()).f_59721_;
    }

    @Override
    public void setEditable(boolean editable) {
        ((SignBlockEntity)this.getSnapshot()).f_59721_ = editable;
    }

    @Override
    public boolean isGlowingText() {
        return ((SignBlockEntity)this.getSnapshot()).m_155727_();
    }

    @Override
    public void setGlowingText(boolean glowing) {
        ((SignBlockEntity)this.getSnapshot()).m_155722_(glowing);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)((SignBlockEntity)this.getSnapshot()).m_59753_().m_41060_());
    }

    @Override
    public void setColor(DyeColor color) {
        ((SignBlockEntity)this.getSnapshot()).m_59739_(net.minecraft.world.item.DyeColor.m_41053_((int)color.getWoolData()));
    }

    @Override
    public void applyTo(SignBlockEntity sign) {
        super.applyTo(sign);
        if (this.lines != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                String line;
                String string = line = this.lines[i] == null ? "" : this.lines[i];
                if (line.equals(this.originalLines[i])) continue;
                sign.m_59732_(i, CraftChatMessage.fromString(line)[0]);
            }
        }
    }

    public static void openSign(Sign sign, Player player) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"sign == null");
        Preconditions.checkArgument((boolean)sign.isPlaced(), (Object)"Sign must be placed");
        Preconditions.checkArgument((sign.getWorld() == player.getWorld() ? 1 : 0) != 0, (Object)"Sign must be in same world as Player");
        SignBlockEntity handle = (SignBlockEntity)((CraftSign)sign).getTileEntity();
        handle.f_59721_ = true;
        ((CraftPlayer)player).getHandle().m_7739_(handle);
    }

    public static Component[] sanitizeLines(String[] lines) {
        Component[] components = new Component[4];
        for (int i = 0; i < 4; ++i) {
            components[i] = i < lines.length && lines[i] != null ? CraftChatMessage.fromString(lines[i])[0] : new TextComponent("");
        }
        return components;
    }

    public static String[] revertComponents(Component[] components) {
        String[] lines = new String[components.length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = CraftSign.revertComponent(components[i]);
        }
        return lines;
    }

    private static String revertComponent(Component component) {
        return CraftChatMessage.fromComponent(component);
    }
}

